% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{annual_return}
\alias{annual_return}
\title{Compute Annual Returns of a Vector.}
\usage{
annual_return(vec)
}
\arguments{
\item{vec}{a numeric vector of asset returns as an xts object with dates as rownames.}
}
\value{
A numeric vector of annual returns.
}
\description{
This function takes a vector of asset returns and computes annual returns.
}
\examples{

# Compute annual returns of an asset vector
require(xts)
asset_returns_xts <- xts(c(29.2, 30.0, 36.2, 30.4, 38.5, -35.6, 34.5),
order.by = as.Date(c("2017-05-07", "2018-05-07", "2019-05-07",
"2020-05-07", "2021-05-07", "2022-05-07",
"2023-05-07")))
annual_return(asset_returns_xts)


}
\seealso{
\code{\link{weekly_return}}, \code{\link{monthly_return}}
}
