% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{best_dist}
\alias{best_dist}
\title{Find the best distribution based on AIC values}
\usage{
best_dist(aic_df, dist_names)
}
\arguments{
\item{aic_df}{A data frame containing AIC values for different distributions}

\item{dist_names}{A vector of distribution names corresponding to the AIC values}
}
\value{
A data frame with the best distribution for each row based on the minimum AIC value
}
\description{
This function takes in a data frame of AIC values for different distributions
and a vector of distribution names, and returns a data frame with the best
distribution for each row based on the minimum AIC value.
#' You can also write the distribution as "norm" or "cauchy" provided they
follow the order in the data frame.
}
\note{
This function takes the data frame obtained from \code{fit_multiple_dist} function
}
\examples{

data <- asset_loader(system.file("extdata", package = "StockDistFit"), c("AAPL", "TSLA"), "Close")
df = fit_multiple_dist(c("norm_fit", "cauchy_fit"), data)
best_dist(df, c("norm_fit", "cauchy_fit"))


}
