% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{nig_fit}
\alias{nig_fit}
\title{Fit Normal Inverse Gaussian (NIG) Distribution to a vector of returns/stock prices.}
\usage{
nig_fit(vec)
}
\arguments{
\item{vec}{A numeric vector of data.}
}
\value{
A list with the following elements:
\describe{
\item{params}{The estimated parameters of the NIG distribution: location, scale, skewness, and shape.}
\item{aic}{The Akaike Information Criterion (AIC) for the NIG distribution fit.}
\item{bic}{The Bayesian Information Criterion (BIC) for the NIG distribution fit.}
}
}
\description{
This function fits the Normal Inverse Gaussian (NIG) Distribution to a given data vector using the \code{nig_fit} function from
the \code{fBasics} package. It returns the estimated parameters along with the AIC and BIC values for the fitted
distribution.
}
\examples{

stock_prices <- c(10, 11, 12, 13, 14, 17, 18)
returns <- diff(log(stock_prices))
nig_fit(returns)

}
\seealso{
\code{\link{norm_fit}}, \code{\link{t_fit}}, \code{\link{cauchy_fit}}, \code{\link{ghd_fit}}, \code{\link{hd_fit}},
\code{\link{sym.ghd_fit}}, \code{\link{sym.hd_fit}}, \code{\link{vg_fit}}, \code{\link{sym.vg_fit}}
\code{\link{ged_fit}}, \code{\link{skew.t_fit}}, \code{\link{skew.normal_fit}}, \code{\link{skew.ged_fit}}
}
