% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\docType{methods}
\name{getSeasons}
\alias{getSeasons}
\alias{getSeasons,storm-method}
\alias{getSeasons,stormsList-method}
\title{Getting cyclonic seasons of the storms}
\usage{
getSeasons(s)

\S4method{getSeasons}{storm}(s)

\S4method{getSeasons}{stormsList}(s)
}
\arguments{
\item{s}{\code{storm} or \code{stormsList} object.}
}
\value{
numeric vector.
}
\description{
The \code{getSeasons()} function  returns the cyclonic season
of each storm in a \code{storm} or \code{stormsList} object.
}
\examples{
\donttest{
#Creating a stormsDataset
sds <- defStormsDataset()

#Getting storm track data for all storms near New Caledonia
sts <- defStormsList(sds=sds, loi = "New Caledonia")

#Getting the cyclonic seasons of the storms from the sts object
getSeasons(sts)
}
}
