% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defStormsList.R
\docType{class}
\name{storm-class}
\alias{storm-class}
\alias{storm}
\title{\code{storm}  object}
\value{
A \code{storm} object.
\itemize{
\item \code{name}, character.
\item \code{season}, numeric.
\item \code{scale}, numeric.
\item \code{obs}, numeric.
\item \code{obs.all}, data.frame.
}
}
\description{
Gather all the needed informations to model a single storm
}
\section{Slots}{

\describe{
\item{\code{name}}{character. Name of the storm}

\item{\code{season}}{numeric. Cyclonic season in which the storm has occured}

\item{\code{scale}}{numeric. Maximum scale category reached}

\item{\code{obs}}{numeric vector. Indices of observations within the location of
interest extented with its corresponding buffer (See \code{stormsList} class)}

\item{\code{obs.all}}{data.frame. Contains all of the observations available. An
observation is made up of several fields which are:
\itemize{
\item \code{iso.time}, Date and hours of observations (UTC)
\item \code{lon}, Longitude coordinate (Eastern degree)
\item \code{lat}, Latitude coordinate (Northern degree)
\item \code{msw}, Maximum Sustained Wind (m/s)
\item \code{scale}, Level in the chosen scale
}
The following field is not mandatory but highly recommended
\itemize{
\item \code{rmw}, Radius of Maximum Wind (km)
}
Also, the following fields are only mandatory to perform Holland and Boose
models (See \code{Details})
\itemize{
\item \code{pres}, Pressure at the center (pa)
\item \code{poci}, Pressure of the Outermost Closed Isobar (pa)
}}
}}

