% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\encoding{UTF-8}
\name{vEst}
\alias{vEst}
\title{Variance Estimation for balanced sample}
\usage{
vEst(Xauxs, piks, ys)
}
\arguments{
\item{Xauxs}{A matrix of size (\eqn{n} x \eqn{p}) of auxiliary variables on which the sample must be balanced.}

\item{piks}{A vector of inclusion probabilities. The vector has the size of the sample \eqn{s}.}

\item{ys}{A variable of interest.The vector has the size \eqn{n} of the sample \eqn{s}.}
}
\value{
Estimated variance of the horvitz-thompson estimator.
}
\description{
Estimated variance approximation calculated as the conditional variance with respect to the balancing equations of a particular Poisson design. See Tillé (2020)
}
\examples{

N <- 100 
n <- 40
x1 <- rgamma(N,4,25)
x2 <- rgamma(N,4,25)

pik <- rep(n/N,N)
Xaux <- cbind(pik,as.matrix(matrix(c(x1,x2),ncol = 2)))
Xspread <- cbind(runif(N),runif(N))
  

s <- balseq(pik,Xaux,Xspread)
  
y <- Xaux\%*\%c(1,1,3) + rnorm(N,120) # variable of interest
  
vEst(Xaux[s,],pik[s],y[s])
vDBS(Xaux[s,],Xspread[s,],pik[s],y[s])
vApp(Xaux,pik,y)

}
\references{
Tillé, Y. (2020), Sampling and Estimation from finite populations, Wiley,
}
\seealso{
\code{\link{vDBS}} \code{\link{vApp}}
}
