% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbology.R
\name{symbology}
\alias{symbology}
\title{Draws the symbols of a collection}
\usage{
symbology(
  collection,
  sym,
  x,
  y,
  xfac = 1,
  yfac = 1,
  xadj = 0,
  yadj = 0,
  col = NA,
  border = "black",
  density = NA,
  angle = 45,
  lty = par("lty"),
  lwd = par("lwd"),
  scol = border,
  slty = lty,
  slwd = lwd
)
}
\arguments{
\item{collection}{a collection object (e.g. oufti)}

\item{sym}{the name of the symbols in the collection}

\item{x, y}{numeric vectors of coordinates where the object should be
drawn.}

\item{xfac}{the x size factor.}

\item{yfac}{the y size factor.}

\item{xadj}{value specifying the x adjustment of the drawing.}

\item{yadj}{value specifying the y adjustment of the drawing.}

\item{col}{the polygons background color. If density is specified with
a positive value this gives the color of the shading lines.}

\item{border}{the lines color.}

\item{density}{the density of shading lines, in lines per inch. The
default value of NULL means that no shading lines are drawn.}

\item{angle}{the slope of shading lines, given as an angle in degrees
(counter-clockwise)}

\item{lty, lwd}{the border line type and width, see ?par for details.}

\item{scol, slty, slwd}{the colour, type and width of the shading lines.}
}
\description{
Draws all the required symbols from a collection of them
}
\examples{
# Create a data frame for all the required information ----

a <- data.frame(name = c("ammonite", "marcassite",
                         "nodule.point", "ammonite"),
                x = c(1,3,5,1),
                y = c(1,3,5,5),
                col = c(NA, "grey90",
                        "grey50", "grey90"))

# Draw them all in a single line of code ----

plot.new()
plot.window(xlim = c(0,6), ylim = c(0, 6))

axis(1)
axis(2, las = 1)

symbology(oufti99, a$name, a$x, a$y, col = a$col)

}
\seealso{
Similar functions: \code{\link{centresvg}}, \code{\link{framesvg}}
and \code{\link{placesvg}}

Collections available in StratigrapheR: \code{\link{oufti99}}
}
