
## `StroupGLMM`: R Codes and Datasets for Generalized Linear Mixed Models: Modern Concepts, Methods and Applications by Walter W. Stroup

###### Version : [0.2.0](https://myaseen208.com/StroupGLMM/); Copyright (C) 2016-2024: License: [GPL-2\|GPL-3](https://www.r-project.org/Licenses/)

##### *Muhammad Yaseen<sup>1,2</sup>, Adeela Munawar<sup>2</sup>, Walter W. Stroup<sup>3</sup>, and Kent M. Eskridge<sup>3</sup>*

1.  School of Mathematical & Statistical Sciences, Clemson University,
    Clemson, South Carolina, USA

2.  Department of Mathematics and Statistics, University of Agriculture
    Faisalabad, Pakistan

3.  Department of Statistics, University of Nebraska Lincoln, NE, USA

------------------------------------------------------------------------

[![minimal R
version](https://img.shields.io/badge/R%3E%3D-3.5.0-6666ff.svg)](https://cran.r-project.org/)
[![License: GPL
v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version-last-release/StroupGLMM)](https://cran.r-project.org/package=StroupGLMM)
[![rstudio mirror
downloads](https://cranlogs.r-pkg.org/badges/grand-total/StroupGLMM?color=green)](https://CRAN.R-project.org/package=StroupGLMM)
<!-- [![packageversion](https://img.shields.io/badge/Package%20version-0.2.3.3-orange.svg)](https://github.com/myaseen208/StroupGLMM) -->

[![develVersion](https://img.shields.io/badge/devel%20version-0.1.0-orange.svg)](https://github.com/myaseen208/StroupGLMM)

<!-- [![GitHub Download Count](https://github-basic-badges.herokuapp.com/downloads/myaseen208/StroupGLMM/total.svg)] -->

[![Project Status:
WIP](https://www.repostatus.org/badges/latest/inactive.svg)](https://www.repostatus.org/#inactive)
[![lifecycle](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)
[![Last-changedate](https://img.shields.io/badge/last%20change-2024--09--30-yellowgreen.svg)](https://github.com/myaseen208/StroupGLMM)
\*\*\*

## Description

R Codes and Datasets for Stroup, W. W. (2012). Generalized Linear Mixed
Models Modern Concepts, Methods and Applications, CRC Press.

## Installation

The package can be installed from CRAN as follows:

``` r
install.packages("StroupGLMM", dependencies = TRUE)
```

The development version can be installed from github as follows:

``` r
if (!require("remotes")) install.packages("remotes")
remotes::install_github("myaseen208/StroupGLMM")
```

## What’s new

To know whats new in this version type:

``` r
news(package = "StroupGLMM")
```

## Links

[CRAN page](https://cran.r-project.org/package=StroupGLMM)

[Github page](https://github.com/myaseen208/StroupGLMM)

[Documentation website](https://myaseen208.com/StroupGLMM/)

## Citing `StroupGLMM`

To cite the methods in the package use:

``` r
citation("StroupGLMM")
Please, support this project by citing it in your publications!

  Yaseen M, Munawar A, Stroup WW, Eskridge KM (2016). _StroupGLMM: R
  Codes and Datasets for Generalized Linear Mixed Models: Modern
  Concepts, Methods and Applications by Walter W. Stroup_.

A BibTeX entry for LaTeX users is

  @Manual{,
    title = {StroupGLMM: R Codes and Datasets for Generalized Linear Mixed Models: Modern Concepts, Methods and Applications by Walter W. Stroup},
    author = {Muhammad Yaseen and Adeela Munawar and Walter W. Stroup and Kent M. Eskridge},
    year = {2016},
    journal = {The Comprehensive R Archive Network (CRAN)},
  }
```
