% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StructuralDecompose.R
\name{AnomalyDetection}
\alias{AnomalyDetection}
\title{Automatic Anomaly detection}
\usage{
AnomalyDetection(
  timeseries,
  frequency = 52,
  conf_level = 1.5,
  breaks,
  window_len = 14
)
}
\arguments{
\item{timeseries}{Given time series}

\item{frequency}{Timeseries frequency, defaults to 12 points}

\item{conf_level}{Confidence level for Anomaly detection}

\item{breaks}{breakpoints identified}

\item{window_len}{Window length for anomaly detection}
}
\value{
the list of anomalies in the time series, along with the time series plot
}
\description{
Automatic Anomaly detection
}
\examples{
AnomalyDetection(timeseries = StructuralDecompose::Nile_dataset[,1], breaks = c(4, 50, 80))

AnomalyDetection(timeseries = runif(n = 50, min = 1, max = 10),  breaks = c(4, 20, 30))
}
