% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StructuralDecompose.R
\name{StructuralDecompose}
\alias{StructuralDecompose}
\title{Main decomposition algorithm}
\usage{
StructuralDecompose(
  Data,
  frequency = 12,
  break_algorithm = "strucchange",
  smoothening_algorithm = "lowess",
  break_level = 0.05,
  median_level = 0.5,
  mean_level = 0.5,
  level_length = 12,
  conf_level = 0.5,
  window_len = 12,
  plot = FALSE
)
}
\arguments{
\item{Data}{Time series required}

\item{frequency}{Frequency of the tine series}

\item{break_algorithm}{breakpoints algorithm used. Defaults to strucchange}

\item{smoothening_algorithm}{Smoothing algorithm used. Defaults to lowess}

\item{break_level}{Break level for the breakpoints algorithm}

\item{median_level}{Average median distance between two level}

\item{mean_level}{Average mean distance between a group of points near breakpoints}

\item{level_length}{Minimum number of points required to determine a level}

\item{conf_level}{Confidence level for Anomaly detection, best to keep this a static value}

\item{window_len}{Length of the Moving window for Anomaly Detection}

\item{plot}{True of False indicating if you want the internal plots to be generated}
}
\value{
The decomposed time series along with a host of other metrics
}
\description{
Main decomposition algorithm
}
\examples{
StructuralDecompose(Data = StructuralDecompose::Nile_dataset[,1])

StructuralDecompose(Data = runif(n = 50, min = 1, max = 10))
}
