% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regstype.R
\name{regstype}
\alias{regstype}
\title{Fit a regression model using the S-type estimators.}
\usage{
regstype(y, x)
}
\arguments{
\item{y}{Dependent variables (Dataframe, vector).}

\item{x}{Explanatory variables (Dataframe, matrix).}
}
\value{
A list containing the model coefficients and diagnostics.
}
\description{
This function fits a regression model using the S-type estimators.
}
\examples{
library(datasets)
data(airquality)
str(airquality)
cleanairquality=na.omit(airquality)
Y1=cleanairquality$Ozone
X1=cleanairquality$Temp
X2=cleanairquality$Wind
X3=cleanairquality$Solar.R
x=data.frame("X1"=X1,"X2"=X2,"X3"=X3)
y=data.frame("Y"=Y1)
regstype(y,x)
}
