SIMEX_S1_cox = function(surv, status, X, Sigma_e, psi, k ) {  # method = 1 => lasso; method = 2 => adaptive lasso


## Algorithm settings

t = NULL
n = dim(X)[1]
p = dim(X)[2]
mu_e = rep(0,p)
Sigma_e = Sigma_e

y <- Surv(surv, status)
W = X
e = mvrnorm(n, mu_e, Sigma_e, tol = 1e-6, empirical = FALSE, EISPACK = FALSE)
W_S = W + sqrt(psi) * e

## End of settings


for(k in 1:n) {

graph =  as.numeric(W_S[k,]) %*% t(as.numeric(W_S[k,]))
graph = graph - diag(diag(graph))

t = rbind(t, c(W_S[k,], c(graph)))

}



cv.ridge <- glmnet(t, y, family='cox', alpha=0)
w3 <- 1/abs(matrix(coef(cv.ridge, s=min(cv.ridge$lambda))
[, 1][2:(ncol(t)+1)] ))^1 ## Using gamma = 1
w3[which(w3[,1] == Inf)] <- 9000
w3[is.na(w3)] = 9000
#w3[4970,1] = 900


glmnet(t, y, family="cox", alpha = 1, penalty.factor=w3) -> cox

coef.beta1 = cox$beta  # extract coefficients at all values of lambda,  including the intercept
dev1 = deviance(cox)
reg.df1 = cox$df

obj1 = -dev1 + log(n) * reg.df1


lambda.ind1 = which.max(obj1)
coef.beta1 = coef.beta1[, lambda.ind1]


 return(coef.beta1)
}

