% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gt.R
\name{Gt}
\alias{Gt}
\title{Gt}
\usage{
Gt(object, timepoint)
}
\arguments{
\item{object}{object of class \code{Surv} created by Surv function.}

\item{timepoint}{any point in time you want to get the Kaplan–Meier estimate of the censoring.}
}
\value{
The Kaplan–Meier estimate of the censoring in (0,1).
}
\description{
G(t)=P(C>t) denote the Kaplan-Meier estimate of the censoring distribution which is used to adjust for censoring.
Gt is used to calculate G(t) at any timepoint you want.
}
\examples{
library(survival)
time <- rexp(50)
status <- sample(c(0, 1), 50, replace = TRUE)
pre_sp <- runif(50)
timepoint <- runif(1)
Gt(Surv(time, status), timepoint)

}
\references{
Graf, Erika, Schmoor, Claudia, Sauerbrei, & Willi, et al. (1999). Assessment and comparison of prognostic classification schemes for survival data. Statist. Med., 18(1718), 2529-2545.

Kaplan, E. L. , &  Meier, P. . (1958). Nonparametric estimation from incomplete observations. Journal of the American Statistical Association, 53, 457-481.
}
\author{
Hanpu Zhou \email{zhouhanpu@csu.edu.cn}
}
