% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans.haz.R
\name{trans.haz}
\alias{trans.haz}
\title{Transformed hazards model with sparse longitudinal covariates}
\usage{
trans.haz(data, n, nknots, norder, tau, s, h)
}
\arguments{
\item{data}{An object of class tibble. The structure of the tibble must be: tibble(id = id, X = failure time, covariates = observation for covariates, obs_times = observation times, delta = censoring indicator).}

\item{n}{An object of class integer. The sample size.}

\item{nknots}{An object of class integer. The number of knots for B-spline.}

\item{norder}{An object of class integer. The order of B-spline.}

\item{tau}{An object of class numeric. The maximum follow-up time.}

\item{s}{An object of class numeric. The parameter for Box-Cox transformation.}

\item{h}{An object of class vector. If use auto bandwidth selection, the structure of the vector must be: h = c(the maximum bandwidth, the minimum bandwidth, the number of bandwidth divided). If use fixed bandwidth, h is the chosen bandwidth.}
}
\value{
a list with the following elements:
\item{est}{The estimation for the corresponding parameters.}
\item{se}{The estimation for the standard error of the estimated parameters.}
}
\description{
Statistical inference on transformed hazards model with sparse longitudinal covariates. Kernel-weighted log-likelihood and sieve maximum log-likelihood estimation are combined to conduct statistical inference on the hazards function.
}
\examples{


library(dplyr)
library(gaussquad)
library(nleqslv)
library(MASS)
n=200
lqrule64 <- legendre.quadrature.rules(64)[[64]]
simdata <- function(  beta ) {
cen=1
nstep=20
Sigmat_z <- exp(-abs(outer(1:nstep, 1:nstep, "-")) / nstep)
z  <-  2*(pnorm(c(mvrnorm(  1, rep(0,20), Sigmat_z  )))-0.5)
left_time_points <- (0:(nstep - 1)) / nstep
z_fun <- stepfun(left_time_points, c(0,z  ))
h_fun <- function(x) { beta  * z_fun(x)  }
lam_fun <- function(tt) 2 * exp(h_fun(tt))
u <- runif(1)
fail_time <- nleqslv(0, function(ttt)
legendre.quadrature(lam_fun, lower = 0,upper = ttt, lqrule64) + log(u))$x
X <- min(fail_time, cen)
obs=rpois(1,  5)+1
tt= sort(runif(obs, min = 0, max = 1))
obs_times <- tt[which(tt<=cen)]
if (length(obs_times) == 0)
 obs_times <- cen
 covariates_obscov <-z_fun(obs_times)
 return( tibble(X = X,delta = fail_time < cen,
 covariates = covariates_obscov,obs_times = obs_times, censoring = cen  )  )
  }
beta=1
data <- replicate( n, simdata( beta ), simplify = FALSE ) \%>\% bind_rows(.id = "id")
trans.haz(data,n,3,3,1,s=0,n^(-0.35))
}
\references{
Sun, D. et al. (2023) <arXiv:2308.15549>
}
