% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{sp_add_segments}
\alias{sp_add_segments}
\title{Add Segments or Rectangles to a SveltePlot Chart}
\usage{
sp_add_segments(
  sp,
  x_start,
  x_end,
  y_start = "even",
  y_end = "even",
  type = "lines",
  linetype = "solid",
  line_width = 1,
  opacity = 0.2,
  show_legend = TRUE,
  background_color = NULL,
  legend_text = " ",
  tooltip = "",
  font_size = 12,
  text_color = "black",
  x_position = NULL,
  y_position = NULL,
  outline_width = 1,
  outline_color = "black",
  key = NULL
)
}
\arguments{
\item{sp}{A SveltePlot htmlwidget object to which segments or rectangles will be added.}

\item{x_start}{Vector of starting x positions for segments or rectangles. If the x-axis is numeric, this should be
a numeric vector; if the x-axis is date or time, this should be a character vector representing dates.}

\item{x_end}{Vector of ending x positions for segments or rectangles, similar in type to \code{x_start}.}

\item{y_start}{Vector of starting y positions for segments or rectangles. Can be numeric or "auto" to span the entire
y-axis range.}

\item{y_end}{Vector of ending y positions for segments or rectangles, similar in type to \code{y_start}.}

\item{type}{Character vector specifying the type of annotation to add: "lines" for line segments or "rect" for rectangles.
Default is "lines".}

\item{linetype}{Character vector specifying the appearance of the line if type is "lines". Supported values include
"blank", "solid", "dashed", "dotted", "dotdash", "longdash", and "twodash". Custom linetypes can also be defined as strings.}

\item{line_width}{Numeric vector specifying the width of lines if type is "lines". Default is 1.}

\item{opacity}{Numeric vector between 0 and 1 specifying the opacity of the lines or rectangles. Default is 0.5.}

\item{show_legend}{Logical indicating whether to include these segments or rectangles in the chart's legend. Default is TRUE.}

\item{background_color}{Character vector specifying the color(s) for the lines or rectangles. If NULL, a default color scheme is used.}

\item{legend_text}{Character vector specifying custom text for legend entries. Default is NULL, and no legend will be shown.}

\item{tooltip}{Character vector specifying tooltip text to be displayed on hover. Each segment or rectangle can have its
own tooltip text.}

\item{font_size}{Numeric vector specifying the font size of the tooltip text. Default is 12.}

\item{text_color}{Character vector specifying the color of the tooltip text. Default is "black".}

\item{x_position}{Vector of x positions for the tooltips. If NULL, defaults to \code{x_start}.}

\item{y_position}{Vector of y positions for the tooltips. Default is NULL.}

\item{outline_width}{Numeric vector specifying the width of the outline of the rectangles. Default is 1.}

\item{outline_color}{Character vector specifying the color of the outline of the rectangles. Default is "black".}

\item{key}{Character vector specifying keys for the segments or rectangles. Default assigns the keys from 1 to the number of rows in the data set. For more information see \href{https://learn.svelte.dev/tutorial/keyed-each-blocks}{Each keyed block}}
}
\value{
An object of class \code{htmlwidget} representing the plot with segments added.
}
\description{
Adds segments or rectangles to highlight specific areas or differences within a SveltePlot chart.
This function can be used to draw attention to certain data points, ranges, or to compare groups.
}
\examples{

library(SveltePlots)
data("segments")
data("dau")
data("purchases")

sp(
  data = purchases, type = "line",
  mapping = spaes(x = date, y = revenue_roll, group = age),
  colors = c("red", "green", "blue"),
  combine_same_groups = TRUE,
  height = 500
) |>
  sp_add_series(
    data = purchases,
    mapping = spaes(x = date, y = revenue, group = age),
    type = "points",
    alpha = 0.4,
    tooltip = FALSE,
    include_legend = FALSE
  ) |>
  sp_add_series(
    data = purchases[purchases$revenue == max(purchases$revenue), ],
    mapping = spaes(x = date, y = revenue, group = age),
    type = "points",
    size = 5,
    tooltip = FALSE
  ) |>
  sp_add_segments(
    x_start = "2000-01-12", x_end = "2000-01-17",
    y_start = "auto", y_end = "auto",
    type = "rect",
    opacity = 0.2,
    background_color = "black",
    text_color = "white",
    show_legend = TRUE,
    legend_text = "Highest Revenue Day",
    tooltip = "Revenue: <strong>$13179</strong>"
  ) |>
  sp_add_arrows(
    x_start = c("2000-03-01", "2000-03-01"), x_end = c("2000-01-15", "2000-01-15"),
    y_start = c(8000, 12000), y_end = c(10000, 13000),
    arrow_head = c(0, 0),
    size = c(200, 200),
    curvature = c(0.2, 0.4),
    direction = c("downward", "downward"),
    color = c("black", "black"),
    arrow_head_type = c("triangle", "triangle")
  ) |>
  sp_add_text(
    x = c("2000-02-01", "2000-02-20"),
    y = c(12500, 8500),
    text = c(
      "This was the highest revenue day",
      "Window of Some Event Happening"
    )
  )










sp <- sp(
  data = dau,
  type = "line",
  spaes(x = date, y = DAU),
  tooltip = FALSE
) |>
  sp_add_series(
    data = dau,
    mapping = spaes(x = date, y = DAU),
    type = "points",
    size = 4,
    tooltip = TRUE,
  ) |>
  sp_add_segments(
    x_start = segments$start_date,
    x_end = segments$end_date,
    y_start = "even",
    y_end = "even",
    type = "rect",
    opacity = 0.2,
    background_color = segments$colors,
    text_color = "white",
    show_legend = TRUE,
    legend_text = segments$event_type,
    tooltip = unlist(segments$extra_details),
    key = segments$key
  ) |>
  sp_title("DAU", font_size = 24) |>
  sp_x_axis(rotation_axis_ticks = -30)

sp
}
