% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splash_swim_parse.R
\name{swim_parse_splash}
\alias{swim_parse_splash}
\title{Formats Splash style swimming and diving data read with \code{read_results}
into a data frame}
\usage{
swim_parse_splash(
  file_splash,
  avoid_splash = avoid,
  typo_splash = typo,
  replacement_splash = replacement,
  format_results = TRUE,
  splits = FALSE,
  split_length_splash = split_length,
  relay_swimmers_splash = relay_swimmers
)
}
\arguments{
\item{file_splash}{output from \code{read_results}}

\item{avoid_splash}{a list of strings.  Rows in \code{file_splash} containing
these strings will not be included. For example "Pool:", often used to
label pool records, could be passed to \code{avoid_splash}.  The default is
\code{avoid_default}, which contains many strings similar to "Pool:", such
as "STATE:" and "Qual:".  Users can supply their own lists to
\code{avoid_splash}. \code{avoid_splash} is handled before \code{typo_splash}
and \code{replacement_splash}.}

\item{typo_splash}{a list of strings that are typos in the original results.
\code{swim_parse} is particularly sensitive to accidental double spaces, so
"Central  High School", with two spaces between "Central" and "High" is a
problem, which can be fixed.  Pass "Central  High School" to
\code{typo_splash}. Unexpected commas as also an issue, for example "Texas,
University of" should be fixed using \code{typo_splash} and
\code{replacement_splash}}

\item{replacement_splash}{a list of fixes for the strings in
\code{typo_splash}.  Here one could pass "Central High School" (one space
between "Central" and "High") and "Texas" to \code{replacement_splash} fix
the issues described in \code{typo_splash}}

\item{format_results}{should the results be formatted for analysis (special
strings like \code{"DQ"} replaced with \code{NA}, \code{Finals} as
definitive column)?  Default is \code{TRUE}}

\item{splits}{either \code{TRUE} or the default, \code{FALSE} - should
\code{swim_parse} attempt to include splits.}

\item{split_length_splash}{either \code{25} or the default, \code{50}, the
length of pool at which splits are recorded.  Not all results are
internally consistent on this issue - some have races with splits by 50 and
other races with splits by 25.}

\item{relay_swimmers_splash}{should names of relay swimmers be captured?
Default is \code{FALSE}}
}
\value{
returns a data frame with columns \code{Name}, \code{Place},
  \code{Age}, \code{Team}, \code{Prelims}, \code{Finals},
  \code{Points}, \code{Event} & \code{DQ}.  Note all swims will have a
  \code{Finals}, even if that time was actually swam in the prelims
  (i.e. a swimmer did not qualify for finals).  This is so that final results
  for an event can be generated from just one column.
}
\description{
Takes the output of \code{read_results} and cleans it, yielding a data frame
of swimming (and diving) results
}
\seealso{
\code{swim_parse_splash} must be run on the output of
  \code{\link{read_results}}
}
