% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_corners.R
\name{fill_corners}
\alias{fill_corners}
\title{Systematically fills a given mesh array (cmesh) with d-dimensional  points representing every corner of a d-dimensional hypercube. The function fills the successive dimensions of each point via depth-first recursion across all d dimensions.}
\usage{
fill_corners(cmesh, shock, shk_curs, dim_curs)
}
\arguments{
\item{cmesh}{The mesh to be filled with corner points}

\item{shock}{The current shock vector being filled}

\item{shk_curs}{Index in cmesh of the shock currently being filled}

\item{dim_curs}{Index in the current shock of the dimension being filled}
}
\value{
A list of:  cmesh - d x 2^d array of corner points being filled, shk_curs - last point in cmesh that was filled
}
\description{
Systematically fills a given mesh array (cmesh) with d-dimensional  points representing every corner of a d-dimensional hypercube. The function fills the successive dimensions of each point via depth-first recursion across all d dimensions.
}
