% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian_parts.R
\name{day_of_week}
\alias{day_of_week}
\alias{day_of_month}
\alias{day_of_year}
\alias{days_remaining}
\alias{week_of_month}
\alias{week_of_year}
\alias{month_of_year}
\alias{year}
\title{Compute granularities from dates}
\usage{
day_of_week(date, ...)

day_of_month(date)

day_of_year(date)

days_remaining(date)

week_of_month(date, first_day = "Monday")

week_of_year(date, first_day = "Monday")

month_of_year(date)

year(date)
}
\arguments{
\item{date}{A vector of dates}

\item{...}{Other arguments used for specific calendars}

\item{first_day}{Character denoting first day of the week. Default is \code{"Monday"}}
}
\value{
A vector of numerical values for the requested granularity. In the case of \code{day_of_week()}, it returns a character vector of the name of the day of the week, or a numeric vector if \code{numeric = TRUE} is specified.
}
\description{
Compute days, weeks, or months from a vector of dates. These work for Gregorian
dates, and for some other calendars where it makes sense. In particular, \code{day_of_week}
has been implemented for many calendars that contain the concept of a week. Similarly,
\code{day_of_month}, \code{day_of_year} and \code{days_remaining} will work for several calendars.
}
\details{
\code{week_of_year()} returns the ISO 8601 week number with \code{first_day} as Monday.
Under this standard, week 1 of a year is defined as the first week with at least 4 days in the year;
equivalently, it is the week  containing 4 January. There is no week 0; instead week 1 of a year may
begin in the previous calendar year.

\code{week_of_month()} is defined analogously where week 1 of a month is the first week with at least
4 days in the month; equivalently, it is the week containing the 4th day of the month. There is no week 0;
instead week 1 of a month may begin in the previous calendar month.

\code{days_remaining()} returns the number of days remaining in the year.

Other functions should be self-explanatory.
}
\examples{
april2025 <- gregorian_date(2025, 4, 1:30)
day_of_week(april2025)
day_of_month(april2025)
day_of_year(april2025)
days_remaining(april2025)
week_of_month(april2025)
week_of_year(april2025)
month_of_year(april2025)
}
