% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneCatCI.R
\name{oneCatCI}
\alias{oneCatCI}
\title{Confidence intervals and standard errors for one synthetic categorical variable of derived with multiply imputed datasets.}
\usage{
oneCatCI(obs_data, imp_data_list, type, var, sig = 6, alpha = 0.05)
}
\arguments{
\item{obs_data}{The original dataset to which the next will be compared, of the type "data.frame".}

\item{imp_data_list}{A list of datasets that are either synthetic or contain imputed values.}

\item{type}{Specifies which type of datasets are in \code{imp_data_list}.  Options are "fully" and "partially".}

\item{var}{The categorical variable being checked.  Should be of type "factor".}

\item{sig}{The number of significant digits in the output dataframe.  Defaults to 6.}

\item{alpha}{Test size, defaults to 0.05.}
}
\value{
This function returns a dataframe with the variable's responses, observed values, lower and upper limits of the confidence interval, standard error, and "YES"/"NO" indicating whether or not the observed value is within the confidence interval.
}
\description{
This function will calculate confidence intervals and standard errors from the proportional responses of multiply imputed datasets for a specified categorical variable, and also gives a YES/NO indicator for whether or not the observed value is within the confidence interval.
The confidence intervals and standard errors are calculated from variance formulas that are specific to whether the multiple imputed datasets are fully or partially synthetic.  See reference for more information.
}
\details{
This function was developed with the intention of making the job of researching synthetic data utility a bit easier by providing another way of measuring utility.
}
\examples{
#PPA is observed data set, PPAm5 is a list of 5 partially synthetic data sets derived from PPA.
#sex is a categorical variable within these data sets. 3 significant digits are desired.

oneCatCI(obs_data=PPA, imp_data_list=PPAm5, type="partially", var="sex", sig=3)
}
\references{
\insertRef{adapt}{SynthTools}
}
\keyword{fully}
\keyword{imputation}
\keyword{multiple}
\keyword{multiply}
\keyword{partial}
\keyword{synds}
\keyword{synth}
\keyword{synthetic}
\keyword{utility}
