% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdcm.plot.R
\name{tdcm.plot}
\alias{tdcm.plot}
\title{Plotting TDCM Results}
\usage{
tdcm.plot(results, attribute.names = c(), group.names = c())
}
\arguments{
\item{results}{results from \code{\link{tdcm.summary}} or \code{\link{mg.tdcm.summary}}}

\item{attribute.names}{an optional vector of attribute names to include in plots.}

\item{group.names}{an optional vector of group names to include in plots.}
}
\value{
No return value, called for side effects.
}
\description{
\code{tdcm.plot()} visualizes the results from TDCM analyses.
}
\examples{
\donttest{
## Example 1: T = 2, A = 4
data(data.tdcm01, package = "TDCM")
dat1 = data.tdcm01$data
qmat1 = data.tdcm01$q.matrix

#estimate TDCM with invariance assumed and full LCDM
m1 = TDCM::tdcm(dat1, qmat1, num.time.points = 2, invariance = TRUE, rule = "GDINA")

#summarize results with tdcm.summary function
results1 = TDCM::tdcm.summary(m1, num.time.points = 2)

#plot results
TDCM::tdcm.plot(results1, attribute.names = c("Addition", "Subtraction",
"Multiplication", "Division"))
}

}
