% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Points.TLineSeg.R
\name{Points.TLineSeg}
\alias{Points.TLineSeg}
\title{Sample k equally spaced points on a max- or min-plus tropical line segment}
\usage{
Points.TLineSeg(D1, D2, k = 20, tadd = max)
}
\arguments{
\item{D1}{point in the tropical projective torus}

\item{D2}{point in the tropical projective torus}

\item{k}{number of points}

\item{tadd}{function; max indicates max-plus addition, min indicates min-plus
addition. Defaults to max}
}
\value{
matrix of k equally spaced points on a tropical line segment
}
\description{
This function calculates k equally spaced points on a tropical line segment
}
\examples{
D1 <-c(0,4,2)
D2 <- c(0,7,-1)
Points.TLineSeg(D1, D2, k = 5)
Points.TLineSeg(D1, D2, k = 5,tadd=min)
}
\author{
Ruriko Yoshida \email{ryoshida@nps.edu}
}
