% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StepDiscrim.R
\name{StepDiscrim}
\alias{StepDiscrim}
\title{Select the most discriminating variables}
\usage{
StepDiscrim(
  MWA,
  labels,
  maxvars,
  features = c("Var", "Cor", "IQR", "PE", "DM"),
  nCores = 0
)
}
\arguments{
\item{MWA}{MultiWaveAnalysis object obtained with MultiWaveAnalysis function}

\item{labels}{Labeled vector that classify the observations.}

\item{maxvars}{The number of desired values. Must be a positive integer}

\item{features}{A list of characteristics that will be used for the
classification process. To see the available features see
\code{\link{availableFeatures}}}

\item{nCores}{Determines the number of processes that will be used in the
function, by default it uses all but one of the system cores. Must be
a positive integer, where 0 corresponds to the default behavior}
}
\value{
A MultiWaveAnalysis object with the maxvars most discriminant variables.
This object contains:
* Features: A list with the initial computed features
* StepSelection: The maxvars most discriminant variables
* Observations: Number of total observations
* NLevels: Number of levels selected for the decomposition process
* filter: Filter used in the decomposition process
}
\description{
Stepwise discriminant analysis to determine the best subset of variables.
Introduces variables so as to maximize at each step the Lawley-Hotelling
trace (=Rao's V).  This measure is proportional to the mean Mahalanobis
distance.
}
\details{
Based on StepDiscrim of R.E. Strauss
}
\examples{
\donttest{
load(system.file("extdata/ECGExample.rda",package = "TSEAL"))
MWA <- MultiWaveAnalysis(ECGExample, "haar", features = c("var"))
MWADiscrim <- StepDiscrim(
  MWA, c(rep(1, 5), rep(2, 5)), 5,
  c("Var")
)
}
}
\seealso{
\itemize{
\item \code{\link{MultiWaveAnalysis}}
\item \code{\link{StepDiscrimV}}
}
}
