% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{mTSMSN}
\alias{mTSMSN}
\title{Moments of Truncated Scale Mixtures of Skew-Normal Distributions}
\usage{
mTSMSN(mu = 0, sigma2 = 1, lambda = 0, nu = NULL, a = -Inf,
  b = Inf, dist = "SN", empir = TRUE)
}
\arguments{
\item{mu}{Location parameter.}

\item{sigma2}{Scale parameter.}

\item{lambda}{Skewness parameter.}

\item{nu}{Shape parameter.  Must be NULL in case of Skew-Normal distribution.  Must be a bidimensional vector in case of skew-contaminated normal distribution (SCN) and contaminated normal distribution (CN).}

\item{a}{Lower bound.}

\item{b}{Upper bound.}

\item{dist}{Distribution to be used:  "SN" for Skew-Normal model, "ST" for Skew-t model, "SSL" for Skew-slash model and "SCN" for Skew-contaminated Normal model.}

\item{empir}{If TRUE provides the empirical moments.}
}
\value{
Returns the four moments, the skewness (S), kurtosis (k) and coefficient of variation(CV). If “empir = TRUE”, returns also the Empirical moments.
}
\description{
Return the first four moments of the TSMSN distributions (Skew Normal, Skew t, Skew Slash or Skew Contaminated Normal).
}
\details{
For the SMN family, consider lambda = 0. For the Skew-contaminated Normal and Contaminated Normal distribution, each component of the bidimensional vector "nu" must be on (0,1).
}
\examples{
mTSMSN(mu = 1, sigma2 = 1, nu = NULL, lambda = 1, a = -2, b = 2, dist = "SN", empir = TRUE)
}
\references{
Lachos, V. H.; Garay, A. M.; Cabral, C. R. "Moments of truncated scale mixtures of skew-normal distributions." Brazilian Journal of Probability and Statistics (In press).

Basso, Rodrigo M., et al. "Robust mixture modeling based on scale mixtures of skew-normal distributions." Computational Statistics & Data Analysis 54.12 (2010): 2926-2941.
}
