% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balancedcheck.R
\name{balancedcheck}
\alias{balancedcheck}
\title{Balanced check}
\usage{
balancedcheck(v, game = FALSE, binary = FALSE, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{game}{A logical value. By default, \code{game=FALSE}. If set to \code{TRUE}, the balanced cover of the game is also returned.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{tol}{A tolerance parameter, as a non-negative number.\cr
By default, \code{tol=100*.Machine$double.eps}.}
}
\value{
\code{TRUE} if the game is balanced, \code{FALSE} otherwise. If \code{game=TRUE}, the balanced cover of the game is also returned.
}
\description{
This function checks if the given game is balanced and computes its balanced cover.
}
\details{
Let \eqn{v \in G^{N}}. A family \eqn{F} of non-empty coalitions of \eqn{N}
is balanced if there exists a weight family \eqn{\delta^{F} = \{ \delta^{F}_{S} \}_{S \in F}} such that
\eqn{\delta^{F}_{S} > 0} for each \eqn{S \in F} and \eqn{\sum_{S \in F} \delta^{F}_{S} e^{S} = e^{N}},
being \eqn{e^{S}} the characteristic vector of \eqn{S}, that is, the vector \eqn{(e_{i}^{S})_{i \in N}}
in which \eqn{e_{i}^{S}=1} if \eqn{i \in S} and \eqn{e_{i}^{S}=0} if \eqn{i \notin S}).

The game \eqn{v} is balanced if, for each balanced family \eqn{F}, it is true that
\deqn{\sum_{S \in F} \delta^{F}_{S} v(S) \leq v(N).}

The balanced cover of \eqn{v} is the game \eqn{\tilde{v}} defined by
\eqn{\tilde{v}(S)=v(S)} for all \eqn{S \neq N} and
\deqn{\tilde{v}(N) = \max_{\delta \in P}{\sum_{S \subset N} \delta_{S} v(S)},}
being \eqn{P} the set of the weight families associated with the balanced families of \eqn{N}.

A game is balanced if and only if it coincides with its balanced cover.
By the Bondareva-Shapley Theorem, a game has a non-empty core if and only if it is balanced.
}
\examples{
balancedcheck(c(12,10,20,20,50,70,70), game=TRUE)
balancedcheck(c(rep(0,4), rep(30,6), rep(0,4), 50))
v <- runif(2^3-1,0,10) # random three-player game
balancedcheck(v, game=TRUE)
balancedcheck(balancedcheck(v, game=TRUE)$game) # balanced cover is indeed balanced
balancedcheck(runif(2^(15)-1,min=10,max=20)) # random game
}
\references{
Maschler, M., Solan, E., & Zamir, S. (2013). \emph{Game Theory}. Cambridge University Press.
}
\seealso{
\link{totallybalancedcheck}
}
