% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subgame.R
\name{subgame}
\alias{subgame}
\title{Subgame of a coalition}
\usage{
subgame(v, S, binary = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{S}{The position of a coalition, as an integer.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} and \code{S} are introduced according to binary order instead of lexicographic order.}
}
\value{
The characteristic function of the subgame of the given coalition, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
Given a game and a coalition, this function returns the characteristic function of the subgame of the given coalition.
}
\details{
Given \eqn{v\in G^N}, the subgame of coalition \eqn{S \in 2^{N}} is defined by
\eqn{v_S(T)=v(T)} for all \eqn{T\in 2^S}.
}
\examples{
v <- c(0, 0, 0, 0, 2, 3, 4, 5, 6, 9, 1, 15, 20, 30, 100)
S <- 13
subgame(v, S)
n <- 4
for (i in 1 : (2^n-1)) {
  cat("[", i, "]", paste(subgame(v,i)), "\n")
}
subgame(v,15)==v
}
