% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TabaMatrix.R
\name{taba.matrix}
\alias{taba.matrix}
\title{Robust Correlation Matrix}
\usage{
taba.matrix(x, y = NULL, ..., method = c("taba","tabarank","tabwil","tabwilrank"),
            alternative = c("less", "greater", "two.sided"),
            omega)
}
\arguments{
\item{x}{A numeric vector of length greater than 2 must be same length as all other vectors.}

\item{y}{A numeric vector of length greater than 2 must be same length as all other vectors.}

\item{...}{Numeric vector(s) of length equal to x and y. May be of class matrix
or data.frame, whose columns will be compared and whose column's length must be of
equal length to x and y. Not one vector or column name can be "x" or "y."}

\item{method}{A character string of \code{"taba"}, \code{"tabarank"}, \code{"tabwil"}, or
\code{"tabwilrank"} determining if one wants to calculate Taba linear, Taba rank
(monotonic), TabWil, or TabWil rank correlation, respectively. If no method is specified,
the function will output Taba Linear correlation.}

\item{alternative}{Character string specifying the alternative hypothesis must be one
of \strong{\code{"less"}} for negative association, \code{"greater"} for
positive association, or \code{"two.sided"} for difference in association.
If the alternative is not specified, the function will default to a two sided test.}

\item{omega}{Numeric allowing the user to alter the tuning constant. If one is not specified,
the function will default to 0.45 for Taba and Taba rank, and 0.1 for TabWil and TabWil rank.
Range is between 0 and 1.}
}
\value{
This function returns the robust association
  between two or more numeric vectors, as a matrix; the distance matrix, as type dist;
  and a p-value matrix corresponding to the correlation matrix.
}
\description{
Calculates a correlation, distance, and p-value matrix using one of the
    specified robust methods Taba linear or Taba rank correlation.
}
\details{
This function uses Taba linear, Taba rank (monotonic), TabWil, or TabWil rank correlation to
   calculate the association of two or more numeric vectors. Numeric vectors under \code{...}
   are combined colomn-wise with x and y. When inserting a single matrix x, the function will
   calculate the correlation matix using the columns of matrix x. \cr
   Matricies or data frames with numeric cells can be inserted in \code{...}, whereby
   each column in the matrix or data frame will be treated as a different vector
   for comparison. Columns must all have different names from each other. No vector
   or column should be named "x" or "y," as these refer to the first two vectors respectively,
   if inserted as a vector or matrix with no name. Missing values in any of the vectors
   are deleted row-wise. \cr
   The default for this function is a two sided test using Taba linear partial correlation,
   with the tuning constant \code{omega} equal to 0.45.
}
\examples{
x = rnorm(100)
y = rnorm(100)
z1 = rnorm(100)
z2 = rnorm(100)
z3 = rnorm(100)
Z = cbind(z1,z3)
colnames(Z) = c("A","B")
taba.matrix(x, y, z1, z2, z3, method = "tabarank")
taba.matrix(x, y, z2, Z, alternative = "less", omega = 0.4)
taba.matrix(Z, method = "tabarank")
}
\references{
Tabatabai, M., Bailey, S., Bursac, Z. et al. An introduction to new robust linear
  and monotonic correlation coefficients. BMC Bioinformatics 22, 170 (2021). https://doi.org/10.1186/s12859-021-04098-4
  \cr{\cr{\doi{https://doi.org/10.1186/s12859-021-04098-4}}}
}
\seealso{
\code{\link{taba}} for calculating Taba linear or Taba rank (monotonic) correlations
  \cr\code{\link{taba.test}} for testing Taba linear or Taba rank (monotonic) correlations
  \cr\code{\link{taba.gpartial}} for generalized partial correlations
  \cr\code{\link{taba.partial}} for partial and semipartial correlations
}
