% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{check_temporal_consistency}
\alias{check_temporal_consistency}
\title{Check Consistency of Temporal Predictor Data}
\usage{
check_temporal_consistency(X)
}
\arguments{
\item{X}{A list of numeric matrices or data frames, where each element is
expected to represent a time point, with subjects as rows and predictors
as columns.}
}
\value{
Returns \code{TRUE} invisibly if all consistency checks pass. If a check
fails, it throws a specific error and stops execution.
}
\description{
Verifies that the input list 'X' is properly formatted for the main
\code{temporal_forest} function.
}
\details{
This helper function is called internally by \code{temporal_forest()} to perform
critical input validation before any heavy computation begins. It checks for
two main conditions:
\enumerate{
\item That the input \code{X} is a list containing data for at least two time points.
\item That all data frames or matrices in the list have identical column names in the exact same order.
}
This prevents downstream errors during network construction and modeling, and
provides a clear, informative error message to the user if their data format
is incorrect.
}
\examples{
# --- 1. A valid input that will pass ---
mat1 <- matrix(1:4, nrow = 2, dimnames = list(NULL, c("V1", "V2")))
mat2 <- matrix(5:8, nrow = 2, dimnames = list(NULL, c("V1", "V2")))
good_X <- list(mat1, mat2)

# This will run silently and return TRUE
check_temporal_consistency(good_X)

# --- 2. An invalid input that will fail ---
mat3 <- matrix(9:12, nrow = 2, dimnames = list(NULL, c("V1", "V3"))) # Mismatched colnames
bad_X <- list(mat1, mat3)

# This will throw an informative error
# We wrap it in try() to prevent the example from stopping
try(check_temporal_consistency(bad_X))

}
