% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tendril.R
\name{Tendril}
\alias{Tendril}
\title{Tendril}
\usage{
Tendril(mydata, rotations, AEfreqThreshold = 50, Tag = "Comment",
  Treatments = c("Active", "Placebo"),
  Unique.Subject.Identifier = "Unique.Subject.Identifier",
  Terms = "Dictionary.Derived.Term", Treat = "Actual.Treatment...DB",
  StartDay = "Analysis.Start.Relative.Day", SubjList = NULL,
  SubjList.subject = NULL, SubjList.treatment = NULL,
  SubjList.dropoutday = NULL, compensate_imbalance_groups = FALSE,
  filter_double_events = FALSE, suppress_warnings = FALSE)
}
\arguments{
\item{mydata}{A dataframe containing the data for the tendril calculations}

\item{rotations}{a vector of same length as mydata containing the rotation factors for all the events}

\item{AEfreqThreshold}{The minimum frequency threshold of events to be included in the analysis. Default is 50}

\item{Tag}{A tag or comment associated with the analysis}

\item{Treatments}{The names of the two treatments to be included in the tendril. The first treatment bends to the right and second treatment bends to the left. Must be a vector of two elements and the two elements must be found in the Treatment column}

\item{Unique.Subject.Identifier}{The name of the column containing the unique patients IDs}

\item{Terms}{The name of the column containing the name of the tendrils (e.g. adverse event terms)}

\item{Treat}{The name of the column containing the name of the treatments}

\item{StartDay}{The name column containing the days of the events}

\item{SubjList}{A dataframe containing subject IDs and treatments}

\item{SubjList.subject}{The name of the columns in SubjList containing the subjects IDs}

\item{SubjList.treatment}{The name of the columns in SubjList containing the treatments}

\item{SubjList.dropoutday}{The name of the column in SubjList containing the dropoutday}

\item{compensate_imbalance_groups}{Boolean Whether the rotation factors have been compensated for imbalance in the groups}

\item{filter_double_events}{Boolean whether to filter out events duplicated in subject id and adverse effect}

\item{suppress_warnings}{Boolean whether to suppress warnings from chi squared approximation may be incorrect}
}
\value{
The function return an object of class tendril. The object contains the original dataset added with the tendril coordinates,
all the function arguments and a dataframe with the results from statistical analysis
\itemize{
\item{data$data }{: Dataframe of orginal data, coordinates and stat results}
\item{data$Unique.Subject.Identifier }{: Column containing subject IDs}
\item{data$Terms }{: Column containing the name of the tendrils}
\item{data$Treat }{: Column containing the name of the treatments}
\item{data$StartDay }{: Column containing the days of the events}
\item{data$Treatments }{: The names of the treatments causing the tendrils to bend}
\item{data$AEfreqThreshold }{: The frequency threshold for the events to be included in the analysis}
\item{data$Tag }{: A tag or comment associated with the analysis}
\item{data$n.tot }{: A dataframe with the total number of events for each treatment. Used in the statistical calculations}
\item{data$SubjList }{: A dataframe containing subject IDs and treatments}
\item{data$SubjList.subject }{: The name of the columns in SubjList containing the subjects IDs}
\item{data$SubjList.treatment }{: The name of the columns in SubjList containing the treatments}
\item{data$SubjList.dropoutday }{: The name of the column in SubjList containing the dropoutday}
\item{data$rotation_vector }{: Rotation vector used to generate the tendril}
\item{data$compensate_imbalance_groups }{: Boolean Whether the rotation factors have been compensated for imbalance in the groups}
}
}
\description{
Function to calculate coordinates and statistical measures used to create a tendril plot
}
\details{
The function accepts a dataframe with at least 4 columns named as the arguments Unique.Subject.Identifier, Terms, Treat and StartDay.

Two treatments must be given as arguments, and at least one of the two treatments must be found in the Treatment column

The function returns an object of class tendril. The object contains the coordinates for the tendril plot and the arguments of the tendril function

The result of the function can be plotted with plot()

The result can be saved to file using write.table() with argument row.names = FALSE
}
\examples{
data <- Tendril(mydata = TendrilData,
rotations = Rotations,
AEfreqThreshold=9,
Tag = "Comment",
Treatments = c("placebo", "active"),
Unique.Subject.Identifier = "subjid",
Terms = "ae",
Treat = "treatment",
StartDay = "day",
SubjList = SubjList,
SubjList.subject = "subjid",
SubjList.treatment = "treatment"
)

plot(data)
}
