% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_func_apply.R
\name{test_func_applyMO}
\alias{test_func_applyMO}
\title{General function for evaluating a test function with multivariate output}
\usage{
test_func_applyMO(
  func,
  x,
  numoutdim,
  scale_it,
  scale_low,
  scale_high,
  noise = 0,
  ...
)
}
\arguments{
\item{func}{A function to evaluate}

\item{x}{Input value, either a matrix whose rows are points or
a vector for a single point. Be careful with 1-D functions.}

\item{numoutdim}{Number of output dimensions}

\item{scale_it}{Should the data be scaled from [0, 1]^D to
[scale_low, scale_high]? This means the input data is confined
to be in [0, 1]^D, but the function isn't.}

\item{scale_low}{Lower bound for each variable}

\item{scale_high}{Upper bound for each variable}

\item{noise}{If white noise should be added, specify the
standard deviation for normal noise}

\item{...}{Additional parameters for func}
}
\value{
Function values at x
}
\description{
General function for evaluating a test function with multivariate output
}
\examples{
x <- matrix(seq(0,1,length.out=10), ncol=1)
y <- test_func_apply(sin, x, TRUE, 0, 2*pi, .05)
plot(x,y)
curve(sin(2*pi*x), col=2, add=TRUE)
}
