#' Dataset: plasma.silicon
#' 
#' @description A study was conducted to measure the plasma silicon level in blood within 30 women 
#' who have been taken a silicone implants surgery. Plasma silicon levels (microg per gram dry weight) 
#' were taken prior to surgical placement of the implants. A post-surgery washout period was allowed, 
#' and the plasma silicon levels were retaken. 
#' @aliases plasma.silicon
#' @format A data frame contains 30 rows and 3 variables:
#' \describe{
#'   \item{PatientNo}{Patient Number.}
#'   \item{preoperative}{pre-operative measurement of plasma silicion level.}
#'   \item{postoperative}{post-operative measurement of plasma silicion level.}
#' }
#' 
#' 
#' 
#' @source Riffenburgh, R. H., & Gillen, D. L. (2020). Statistics in medicine. Academic press. Appendix 2 databases
#' @references Riffenburgh, R. H., & Gillen, D. L. (2020). Statistics in medicine. Academic press.
#' @keywords datasets
"plasma.silicon"