% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{CompileDocument}
\alias{CompileDocument}
\title{Compile Document}
\usage{
CompileDocument(x, layersNames, layersCmd)
}
\arguments{
\item{x}{A character vector, each element represents one line of the latex document}

\item{layersNames}{A character vector, with each element representating the environment name to be searched as \code{cmdName} as describe in \code{\link{FindBegin}} and \code{\link{FindEnd}}}

\item{layersCmd}{A character vector, with the same length as \code{layersNames}. with each element representing the environment command to be serached as \code{cmdName} as described in \code{\link{FindCommand}}.}
}
\value{
It returns a list, with each element having a name. Recreating the tree structure identified by  \code{layersNames} and \code{layersCmd} in the text file \code{x}.

It first divides the document into two lists:
\describe{
\item{preamble}{Contains a character vector identifying everything before the \\begin\{document\}}
\item{document}{Contains the tree structure identifying the document}
}

Now, the naming convention for each layer of the document is as follows. We will use the convention \code{<layerName>},  \code{<layerCmd>}.

 Note the convention first, everything that it finds prior to the first environment, it throws it into a character vector that it calls \code{prior_to_<layesName>}.
 After the first environment \code{<layerName>} ends, it assumes that everything from that \code{\\end\{<layerName>\}} onwards corresponding to the next environment, and it will throw it to the prior part of that one.
 \code{post_to_<layerName>}
\describe{
\item{\code{prior_to_layersName}}{Includes everything up to the first \code{\\begin\{<layerName>} without including that line}
\item{\code{1_<layerName>_begin_<layerName>}}{
  Includes the \code{\\begin\{layerName\}} for the 1st section, and everything until it finds the first \code{\\<layerCmd>}}
\item{\code{1_<layerName>_1_<layerCmd>}}{
  Includes everything from the 1\eqn{^{st}} \code{\\<layerCmd>} until the second \code{\\<layerCmd>}, without including the line in which the second command is found
}
\item{\code{1_<layerName>_2_<layerCmd>}}{
 Same thing... and it keeps going until the last  \code{\\<layerCmd>} is found
}
\item{\code{1_<layerName>_end_<layerName>}}{
It includes the \code{\\end\{<layerName>\}} for the 1st section.
}
\item{...}{
It then repeats the same structure for the next environment, changing the naming convention to start with 2_<...> and so on until it does the last environemt}
\item{\code{post_to_<layerName>}}{
After the last layer ends with \code{\\end\{layerName\}}, it throws the rest of the lines into this last character vector}

}

This structure is applied recursively to each \code{i_<layerName>_j_<layerCmd>} of the previous layer to find the structure for the next layer.
The result is a tree of lists, with names that identify the whole structure, and the ending node of each branch is always a character vector

\strong{IMPORTANT NOTE:} Note that this function only rearranges the lines of the document, it can't split a document between a line. So if you want to make sure something always stays together, put them both in the same line. This is intentional, to force a more clear structure on the document that will be parsed

In Summary, the sketch of the tree structure would be:
\itemize{
  \item preamble
  \item Document
        \itemize{
        \item prior_to_LayerName[1]
        \item 1_layerName[1]_begin_layerName[1]
        \item 1_layerName[1]_1_layerCmd[1]
             \itemize{
             \item prior_to_LayerName[2]
             \item 1_layerName[2]_begin_layerName[2]
             \item 1_layerName[2]_1_layerCmd[2]
                  \itemize{
                  \item Continues...
                  }
             \item 1_layerName[2]_2_layerCmd[2]
                  \itemize{
                  \item Continues...
                  }
             \item ...
             \item  post_to_layerName[2]
             }
        \item 2_layerName[1]_begin_layerName[1]
        \item 2_layerName[1]_1_layerCmd[1]
             \itemize{
             \item ...
             }
       \item ...
       \item n_layerName[1]_end_layerName[1]
       \item  post_to_layerName[1]
        }

}

If a  \code{\\<layerCmd>} is not found inside an environment, everything inside that environment is thrown into the begin_layerName part and instead of the numbered environments, an empty character list is added in the middle, with name \code{empty_<layerCmd>} section.
}
\description{
Function that takes a set of lines, \code{x}, that represent a file or a document. And divides it in subsequent layers, structures as a list, as described on the detail section.

It assumes \code{x} is representing a 'LaTeX' file that can be compiled as it is before we make any modifications.
}
\details{
Both \code{layersNames} and \code{layersCmd} must have the same length, since for each index, \code{i}, \code{layersNames[i]} and \code{layersCmd[i]} refer to one layer of the tree structure of the document. Consequent layers must be found inside previous layers.

If it finds the structure of the document to not be completed, it will throw an error.
}
\seealso{
\link{FindStructure} for more information on the details of how the layers are found.

Other Structuring Document: 
\code{\link{DivideFile}()},
\code{\link{FindStructure}},
\code{\link{IsWellSectioned}()},
\code{\link{StructureDocument}()}
}
\concept{Structuring Document}
\keyword{internal}
