% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnswerSheets.R
\name{FindExamAnswers}
\alias{FindExamAnswers}
\title{FindExamAnswers}
\usage{
FindExamAnswers(Document, correctTag, wrongTag = NULL, OutputStartingName = "")
}
\arguments{
\item{Document}{Document, as defined in \code{\link{StructureDocument}}. Remember however that the function \code{\link{StructureDocument}} returns the document and the preamble together in a list.}

\item{correctTag}{String, it should be the name (or regular expression) defining the tag that items that hold a correct answer will have. \code{\\<correctTag>}.}

\item{wrongTag}{String, leave as \code{NULL}, unless you went the output to explicitly show those questions that are incorrect. Again, it could be a}

\item{OutputStartingName}{Internal argument, (it should really be removed after testing that it really does nothing). In theory, this argument starts up the recursive search into the tree for matches. Since the output name will start with this string and a dash afterwards.}
}
\value{
Character vector. Each element identifies one match. The text of the element identifies where that match was found, in terms of the path walked on the tree that it took to get here. The naming convention is specified on details.
}
\description{
It finds the answer for a certain document, given a correct and wrong tag. The output character vector is a collection of all those matches, with the text identifying the section and item that it was found inside the tree structure.
}
\details{
In the document, a correct or wrong item should be identified with a tag. Which shall be a latex command. "\code{\\correct}" "\code{\\wrong}" or whichever. It must be placed somewhere that is not commented-out. (Similar to how the exam class uses the \code{\\CorrectChoice} command to identify a correct answer, instead of using a \code{\\choice}, both tags could be used for this class).

(This is internally used by \code{\link{ConstructAnswerSheet}} to construct that DF of answers by then parsing the vector output from this function and getting that way the output)

If \code{wrongTag} is not null it also provides the information of where a wrong tag is found.

Each output character vectors has a name that identifies all the information necessary to understand where the match was found, relative to both the original document, and the current document we are analizing even if the order of the current document is different.

The name of each element starts with \code{<OutputStartingName>}. After that, for each layer that it digs into, it pastes the following name on the right of the name that it already has:

\code{_<originalname>_<addedname>}

\itemize{
\item
Where \code{<originalname>} is the name that identifies that list at that depth as the naming convention described in \code{\link{StructureDocument}} defines. It identifies therefore the section and subsection refering to the original document. The string \code{"_original"} is added at the end of the name of the environment and the name of the command name to differentitate it.
\item
And where \code{<addedname>} is the name that identifies that list at that depth as the naming convention described in \code{\link{StructureDocument}} defines.
However, this name has section and item numbers refering to the \strong{current} ordering of the document, not  the original ordering.
}

In the last layer, when it finally find the correct or wrong tag. It modifies the \code{<addedname>} that should look like \code{i_secName_j_cmdName} and it replaces cmdName with the correct or wrong tag respectively.

Therefore, each element is a pretty long string identifying all the layers that it took to traverse to get down to the answer. This function was basically used to prevent the use of attributes that bug out unexpectedly, since when passing functions and parsing things looses the attributes.
}
\seealso{
Other Extracting information: 
\code{\link{ConstructAnswerSheet}()},
\code{\link{CountNumberOfSections}()},
\code{\link{GenerateShortAnswerSheet}()}
}
\concept{Extracting information}
\keyword{internal}
