% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_to_python.R
\name{r_to_python}
\alias{r_to_python}
\title{Convert R Code to Python Code}
\usage{
r_to_python(r)
}
\arguments{
\item{r}{The R code file to be converted to Python code. This should be a file path in the form of a character string.}
}
\value{
If the input filename is a "character string", the converted Python code will be returned as a character string. Otherwise, a new Python file will be created with the same name as the input file but with a ".py" extension, and the function will return the file path of the newly created Python file.
}
\description{
This function takes an R code file as input and uses a language model to convert the R code to Python code. The converted Python code is then either returned as a character string or written to a file, depending on the input.
}
\examples{
\dontrun{
# Convert R code to Python code and display the result as a character string
r_to_python("example.R")

# Convert R code to Python code and save it to a file
r_to_python("example.R", output_file = "example.py")
}
}
