% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.data.R
\name{sim.data}
\alias{sim.data}
\title{Create data based on Thurstonian model equations}
\usage{
sim.data(nfactor = 1, nitem, nperson, itf, model = "factor",
  variables = NULL, ints = NULL, lmu = NULL, ivarcov = NULL,
  loadings = NULL, varcov = NULL, graded = FALSE, ncat = NULL,
  thres = NULL, transitive = TRUE, var = 0, fvalues = FALSE,
  sim = TRUE)
}
\arguments{
\item{nfactor}{The number of factors. Defaults to 1.}

\item{nitem}{The number of items.}

\item{nperson}{The number of data points (= respondents) to simulate.}

\item{itf}{A vector defining the items-to-factor relation. For example
`c(1,1,1,2,2,2)` defines six items, the first three correspond to factor 1,
the second three correspond to factor 2.}

\item{model}{The model class from which to simulate. Options are 'simple', 'factor', 'uc' and 'irt'. Defaults to 'factor'.}

\item{variables}{A vector containing the names of paired comparison variables
to return. If `NULL` (default), all variables are returned.}

\item{ints}{A vector defining the latent intercepts of item pairs.}

\item{lmu}{A vector defining the latent means of items.}

\item{ivarcov}{A matrix defining the variance-covariance matrix of the items.}

\item{loadings}{A vector defining the loadings of items.}

\item{varcov}{A matrix defining the variance-covariance matrix of the traits.}

\item{graded}{Logical. Should a graded preference model be simulated? Defaults to `FALSE`.}

\item{ncat}{Numerical. The number of categories to specify for graded preference models. If graded = `FALSE`, ncat is 2.}

\item{thres}{A vector of thresholds to categorize the latent difference response. If no thresholds are given, they are simulated from the distribution of the latent items. If graded = `FALSE`, the thresholds are all 0.}

\item{transitive}{Logical. Should the data be transitive? If `TRUE`, ranking
data is simulated, else paired comparison data is simulated. Defaults to `TRUE`.}

\item{var}{A vector containing the variances for each paired comparison. Defaults to 0.}

\item{fvalues}{Logical. Should simulated factor values be returned? Defaults to `FALSE`.}

\item{sim}{Logical. Should the simulated data be returned? Defaults to `TRUE`.}
}
\value{
Returns a list containing the true factor scores and the data, or a
matrix containing the data.
}
\description{
Simulates a data set of paired comparisons or ranking data based a Thurstonian
latent utility model.
}
\details{
The syntax currently is able to simulate data from the
latent utility model (`'simple'` and `'factor'`; Maydeu-Olivares & Böckenholt, 2005) the 
unconstrained factor model (`'uc'`; Maydeu-Olivares & Böckenholt, 2005) and 
the IRT model(`'irt'`; Maydeu-Olivares & Brown, 2010).
}
\examples{

nfactor <- 3
nitem <- 15
nperson <- 1000
itf <- rep(1:3,5)
varcov <- diag(1,3)

# latent utility means
set.seed(69)
lmu <- runif(nitem, -1, 1)
loadings <- runif(nitem, 0.30, 0.95)

FC <- sim.data(nfactor=nfactor, nitem=nitem, nperson=nperson, itf=itf, 
varcov = varcov, lmu = lmu, loadings=loadings)
    
}
