% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_A.R
\name{error_A}
\alias{error_A}
\title{The l_1 distance between two thin matrices up to a column permuation}
\usage{
error_A(A, A_hat, type = "u")
}
\arguments{
\item{A}{The first p-by-K matrix.}

\item{A_hat}{The second p-by-K matrix.}

\item{type}{The search type for the best permutation. If it's 'u', the search is 
done universially, that is over all possible permuations of the columns of A.
If it's 'g', the search is done greedily, that is at kth step find the closest 
column in the remaining columns of A to the kth column of A_hat in terms of l_1 distance. Greedy search may
result in sub-optimal solutions, but it can be computed much faster than
the universal way when K is large. The default value is 'u'.}
}
\value{
The l_1 distance.
}
\description{
This function computes l_1 distance between two thin matrices up to a column permuation, 
that is to find the smallest sum of absolute value entry-wise difference between two matrices 
over all possible permutations over the columns of the first matrix. This can be done
either universially or greedily.
}
\examples{
# The example uses the runif() function in the 'stats' package
A <- matrix(runif(10*3),10,3)
A_hat <- A + 0.1*matrix(runif(10*3),10,3)
error_A(A, A_hat)
error_A(A, A_hat, type='g')
}
\author{
Minzhe Wang
}
