% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RadiationFunctions.R
\name{diurnal_radiation_variation}
\alias{diurnal_radiation_variation}
\title{Hourly Solar Radiation}
\usage{
diurnal_radiation_variation(doy, S, hour, lon, lat)
}
\arguments{
\item{doy}{\code{numeric} the day of year.}

\item{S}{\code{numeric} solar radiation (\ifelse{html}{\out{W m<sup>-2</sup> d<sup>-1</sup>}}{\eqn{W m^-2 d^-1}{ASCII}}).}

\item{hour}{\code{numeric} hour (0-24).}

\item{lon}{\code{numeric} longitude (degrees).}

\item{lat}{\code{numeric} latitude (degrees).}
}
\value{
\code{numeric} hourly solar radiation (\ifelse{html}{\out{W m<sup>-2</sup>}}{\eqn{W m^-2}{ASCII}}).
}
\description{
The function estimates hourly solar radiation (\ifelse{html}{\out{W m<sup>-2</sup> hr<sup>-1</sup>}}{\eqn{W m^-2 hr^-1}{ASCII}}) as a function of daily global solar radiation (\ifelse{html}{\out{W m<sup>-2</sup> d<sup>-1</sup>}}{\eqn{W m^-2 d^-1}{ASCII}}). Based on \insertCite{Tham2010;textual}{TrenchR} and \insertCite{AlRawahi2011;textual}{TrenchR}.
}
\examples{
diurnal_radiation_variation(doy    = 112, 
                            S = 8000, 
                            hour   = 12, 
                            lon    = -122.33, 
                            lat    = 47.61)

}
\references{
\insertAllCited{}
}
\seealso{
Other microclimate functions: 
\code{\link{air_temp_profile_neutral}()},
\code{\link{air_temp_profile_segment}()},
\code{\link{air_temp_profile}()},
\code{\link{degree_days}()},
\code{\link{direct_solar_radiation}()},
\code{\link{diurnal_temp_variation_sineexp}()},
\code{\link{diurnal_temp_variation_sinesqrt}()},
\code{\link{diurnal_temp_variation_sine}()},
\code{\link{monthly_solar_radiation}()},
\code{\link{partition_solar_radiation}()},
\code{\link{proportion_diffuse_solar_radiation}()},
\code{\link{solar_radiation}()},
\code{\link{surface_roughness}()},
\code{\link{wind_speed_profile_neutral}()},
\code{\link{wind_speed_profile_segment}()}
}
\concept{microclimate functions}
