% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMC.wrap.R
\name{predict.IBIS}
\alias{predict.IBIS}
\title{Prediction method for IBIS}
\usage{
\method{predict}{IBIS}(object, newX = NULL, type = "prob", ...)
}
\arguments{
\item{object}{Object of class \code{"IBIS"}}

\item{newX}{Data frame containing new observations to predict. If not
specified the fitted values will be returned instead.}

\item{type}{Either \code{"prob"} for a probabilistic output or \code{"response"} for
a hard output of the predicted response}

\item{...}{Additional arguments affecting the predictions produced}
}
\value{
Either a matrix of response probabilities for each observation or
a vector of predicted responses for each observation.
}
\description{
Predicts the response of new observations using an object of
class \code{"IBIS"}.
}
\details{
Note that this is a Bayesian prediction method as objects with
class \code{"IBIS"} will provide samples from a posterior.
}
\examples{

\donttest{
# First we generate a co-variate matrix X and binary response vector y
CM <- data.frame(X1 = rnorm(100),X2 = rnorm(100))
rv <- sample(0:1,100,replace=TRUE)

# Now we can obtain 1000 samples from the posterior from a standard
# multivariate normal prior
out <- IBIS.logreg(X = CM,y = rv)

# The fitted values of out can be obtained
predict(out)
predict(out,type = "response")

# We can also predict the response for new data
CM.2 <- data.frame(X1 = rnorm(10),X2 = rnorm(10))
cbind(CM.2,predict(out,newX = CM.2))
}

}
\seealso{
\code{\link[=IBIS.logreg]{IBIS.logreg()}}
}
\keyword{IBIS}
\keyword{predict}
