% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_uve.R
\name{daily_uve}
\alias{daily_uve}
\title{Daily erythemal UV}
\usage{
daily_uve(
  data,
  date,
  longitude,
  latitude,
  temis_path = getwd(),
  region = "europe"
)
}
\arguments{
\item{data}{data frame containing sample IDs, date, longitude, and latitude}

\item{date}{A date vector, usually date of assessment or recruitment.}

\item{longitude}{A numeric vector of longitude values.}

\item{latitude}{A numeric vector of latitude values.}

\item{temis_path}{Path to TEMIS UV files downloaded using \link{temis_uvdec}. Default is current directory.}

\item{region}{Region of TEMIS data required, options are "europe" (default) or "world".}
}
\value{
A numeric vector of ambient daily erythemal UV measurements.
}
\description{
This function extracts total daily ambient erythemal UV dose on a particular date, at a given geographical location (longitude and latitude).
}
\examples{
#uses sample TEMIS file
mysample <- data.frame(id = c("id000016"),
        date = as.Date(c("2010-08-04")),
        longitude = c(-2.10),
        latitude = c(50.5))
uve_example <- system.file("extdata", "uve_example", package="UVdose")
daily_uve(mysample, date, longitude, latitude, temis_path = uve_example)
}
