% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UnitStat.R
\name{UnitStat}
\alias{UnitStat}
\title{Performs Unit Root Test Statistics}
\usage{
UnitStat(y, lag = 0, View_results = "True")
}
\arguments{
\item{y}{Univariate time series or vector to be tested}

\item{lag}{Numeric.Default is 0.Select Lags to view results at different lags. Maximum number of lags is 4}

\item{View_results}{Boolean.Default is False. If True is selected the function returns results for all the 4 lags.}
}
\value{
An object with class UnitStat().
Retunrs with a statement explaining the type of input data and its stability.
lag - Displays results for the lag number selected
View_results - Shows all lag results
}
\description{
'A test to understand the stability of the underlying stochastic data.Helps the user understand whether the random variable under consideration is stationary or non-stationary without any manual interpretation of the results.It further ensures to check all the prerequisites and assumptions which are underlying the unit root test statistics and if the underlying data is found to be non-stationary in all the 4 lags the function diagnoses the input data and returns with an optimised.
}
\examples{
y = runif(50,1,49)
UnitStat(y)
UnitStat(y,View_results = "T") #To view results at all lags
}
\references{
Dickey, D. A. and Fuller, W. A. (1981), Likelihood Ratio Statistics for Autoregressive Time Series with a Unit Root, Econometrica, 49, 1057--1072. Hamilton (1994), Time Series Analysis, Princeton University Press
}
\author{
Ankita Sharma
}
