% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vd_fit.R
\name{vd_fit}
\alias{vd_fit}
\title{Estimation of the generalized additive functional regression models for
variable domain functional data}
\usage{
vd_fit(formula, data, family = stats::gaussian(), offset = NULL)
}
\arguments{
\item{formula}{a formula object with at least one \code{ffvd} term.}

\item{data}{a \code{list} object containing the response variable
and the covariates as the components of the list.}

\item{family}{a \code{family} object specifying the distribution from which the
data originates. The default distribution is \code{\link{gaussian}}.}

\item{offset}{An offset vector. The default value is \code{NULL}.}
}
\value{
An object of class \code{vd_fit}. It is a \code{list} containing the following items:
\itemize{
\item An item named \code{fit} of class \code{sop}. See \link[SOP]{sop.fit}.
\item An item named \code{Beta} which is the estimated functional coefficient.
\item An item named \code{theta} which is the basis coefficient of \code{Beta}.
\item An item named \code{covar_theta} which is the covariance matrix of \code{theta}.
\item An item named \code{M} which is the number of observations points for each curve.
\item An item named \code{ffvd_evals} which is the result of the evaluations of the \code{ffvd}
terms in the formula.
}
}
\description{
The \code{vd_fit} function fits generalized additive functional regression models
for variable domain functional data.
}
\examples{
# VARIABLE DOMAIN FUNCTIONAL DATA EXAMPLE

# set seed for reproducibility
set.seed(42)

# generate example data
data <- data_generator_vd(
  N = 100,
  J = 100,
  beta_index = 1,
  use_x = TRUE,
  use_f = TRUE,
)

# Define a formula object that specifies the model behavior.
# The formula includes a functional form of the variable 'X_se' using 'ffvd'
# with a non-default number of basis functions ('nbasis' is set to c(10, 10, 10)).
# Additionally, it includes a smooth function 'f' applied to 'x2' with 10 segments ('nseg = 10'),
# a second-order penalty ('pord = 2'), and cubic splines ('degree = 3').
# The model also contains the linear term 'x1'.
formula <- y ~ ffvd(X_se, nbasis = c(10, 10, 10)) + f(x2, nseg = 10, pord = 2, degree = 3) + x1

# We can fit the model using the data and the formula
res <- vd_fit(formula = formula, data = data)

# Some important parameters of the model can be accesed as follows
res$Beta # variable domain functional coefficient
res$fit$fitted.values # estimated response variable

# Also, a summary of the fit can be accesed using the summary function
summary(res)

# And a heatmap for an specific beta can be obtained using the plot function
plot(res, beta_index = 1)

}
\seealso{
\code{\link{ffvd}}
}
