% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_d.R
\name{estimate_d}
\alias{estimate_d}
\title{Visualization for Estimating \eqn{d_s}}
\usage{
estimate_d(
  m1 = NULL,
  m2 = NULL,
  sd1 = NULL,
  sd2 = NULL,
  n1 = NULL,
  n2 = NULL,
  d = NULL,
  fill_1 = "lightblue",
  fill_2 = "pink",
  text_color = "black"
)
}
\arguments{
\item{m1}{mean from first group}

\item{m2}{mean from second group}

\item{sd1}{standard deviation from first group}

\item{sd2}{standard deviation from second group}

\item{n1}{sample size for first group}

\item{n2}{sample size for the second group}

\item{d}{estimate of the effect size}

\item{fill_1}{a color code or name to fill the first distribution}

\item{fill_2}{a color code or name to fill the second distribution}

\item{text_color}{a color code or name for the graph text}
}
\value{
Returns a pretty graph

\item{d}{effect size}
\item{graph}{A graph of the distributions of the effect size}
}
\description{
This function displays a visualization of effect sizes.
}
\examples{
estimate_d(d = .25)

estimate_d(m1 = 10, m2 = 8, sd1 = 5, sd2 = 4,
 n1 = 100, n2 = 75)

}
\keyword{effect}
\keyword{estimation}
\keyword{ggplot}
\keyword{size}
\keyword{visualization}
