% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_voxels.R
\name{project_voxels}
\alias{project_voxels}
\title{Project a voxel cloud in a 2D plan formed by two axes of the cartesian coordiantes system.}
\usage{
project_voxels(data, plan, message)
}
\arguments{
\item{data}{a data.frame or data.table containing the x, y, z, ... coordinates of a voxel cloud.}

\item{plan}{character. Defines the projection plan: "xy", "xz" or "yz". Default = "xy".}

\item{message}{logical. If FALSE, messages are disabled. Default = TRUE.}
}
\value{
A data frame of a 2D point cloud containing : x, y coordinates of the pixels and the
number of voxels (nvox), number of points (npts), ratio npts/nvox contained in each pixel.
}
\description{
Project a voxel cloud in a 2D plan formed by two axes of the cartesian coordiantes system.
}
\examples{
#- import tls data
tls=data.table::fread(system.file("extdata", "Tree_t0.asc", package="VoxR"))

#- voxelisation
voxels = VoxR::vox(tls,0.05)

#- project into the xy plan
project_xy = VoxR::project_voxels(voxels,"xy")
VoxR::plot_projection(project_xy) # plot projection

#- project into the xz plan
project_xy = VoxR::project_voxels(voxels,"xz")
VoxR::plot_projection(project_xy) # plot projection
}
\references{
Lecigne, B., Delagrange, S., & Messier, C. (2018). Exploring trees in three dimensions: VoxR, a novel voxel-based R package dedicated to
            analysing the complex arrangement of tree crowns. Annals of botany, 121(4), 589-601.
}
