% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/substract.R
\name{substract_point_clouds}
\alias{substract_point_clouds}
\title{Point clouds substraction: identification of changes between two measuring times.}
\usage{
substract_point_clouds(t0, t1, method, dist, message)
}
\arguments{
\item{t0}{a data.frame or data.table containing the x, y, z, ... coordinates of a point cloud or voxel cloud
acquired at time 0.}

\item{t1}{a data.frame or data.table containing the x, y, z, ... coordinates of a point cloud or voxel cloud
acquired at time 1.}

\item{method}{character. The method to use to identify the difference between t0 and t1. Can be either "hull" or
"distance", see details.}

\item{dist}{numeric. The threshold distance to consider a point is unique to t1 if \code{method = "distance"}.}

\item{message}{logical. If FALSE, messages are disabled. Default = TRUE.}
}
\value{
a data.frame or data.table containing the x, y, z, ... coordinates of points that are unique to t1.
}
\description{
Identify the point that are unique to one of two point clouds
             to detect the changes that occured between two measuring times (e.g. growth,
             branches losses, branch motion). Two methods are available (see details).
}
\details{
If \code{method = "hull"}, the convex hull that wraps t0 is constructed and the difference between t1 and t0 are
         the points outside the convex hull. If \code{method = "distance"}, the points in t1 that are distant (i.e. further than
         \code{dist}) from the points in t0 are returned.
}
\note{
\code{t0} and \code{t1} must be registered in the same coordinates system.

 @references Lecigne, B., Delagrange, S., & Messier, C. (2018). Exploring trees in three dimensions: VoxR, a novel voxel-based R package dedicated to
            analysing the complex arrangement of tree crowns. Annals of botany, 121(4), 589-601.
}
\examples{
#- import datasets
t0=data.table::fread(system.file("extdata", "Tree_t0.asc", package="VoxR"))
t1=data.table::fread(system.file("extdata", "Tree_t1.asc", package="VoxR"))

#- keep only the tree crown
t0 = t0[z>=0,]
t1 = t1[z>=0,]

####- substract t0 to t1 with the hull method
diff = VoxR::substract_point_clouds(t0 = t0,t1 = t1, method = "hull")
#- plot the result (t0 in black, the difference between t1 and t0 in red)
rgl::open3d()
rgl::plot3d(t0,add=TRUE)
rgl::plot3d(diff,col="red",add=TRUE)

####- substract t0 to t1 with the distance based method
diff = substract_point_clouds(t0 = t0,t1 = t1, method = "distance",dist = 0.1)
#- plot the result (t0 in black, the difference between t1 and t0 in red)
rgl::open3d()
rgl::plot3d(t0,add=TRUE)
rgl::plot3d(diff,col="red",add=TRUE)
}
