% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S2MVarSelection.R
\name{OptimalHbi}
\alias{OptimalHbi}
\title{Variable selection using shrinkage priors :: OptimalHbi}
\usage{
OptimalHbi(bi, Hbi)
}
\arguments{
\item{bi}{a vector holding the values of the tuning parameter specified by the user}

\item{Hbi}{The estimated number of signals corresponding to each b.i of numeric data type}
}
\value{
the optimal value (numeric) of tuning parameter and the associated H value
}
\description{
OptimalHbi function will take b.i and H.b.i as input which comes from the result of TwoMeans function. It will return plot from which you can infer about H: the optimal value of the tuning parameter.
}
\examples{

n <- 10
p <- 5
X <- matrix(rnorm(n * p), n, p)
beta <- exp(rnorm(p))
Y <- as.vector(X \%*\% beta + rnorm(n, 0, 1))
df <- data.frame(X, Y)
rv.hs <- bayesreg::bayesreg(Y ~ ., df, "gaussian", "horseshoe+", 110, 100)

Beta <- t(rv.hs$beta)
lower <- 0
upper <- 1
l <- 5
S2Mbeta <- Sequential2MeansBeta(Beta, lower, upper, l)

bi <- S2Mbeta$b.i
Hbi <- S2Mbeta$H.b.i
OptimalHbi(bi, Hbi)

}
\references{
Makalic, E. & Schmidt, D. F.
High-Dimensional Bayesian Regularised Regression with the BayesReg Package
arXiv:1611.06649, 2016

Li, H., & Pati, D.
Variable selection using shrinkage priors
Computational Statistics & Data Analysis, 107, 107-119.
}
