% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{vcov.WH_1d}
\alias{vcov.WH_1d}
\title{Compute variance-covariance matrix of fitted 1D WH model}
\usage{
\method{vcov}{WH_1d}(object, pred = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{"WH_1d"} returned by the \code{\link[=WH]{WH()}} function}

\item{pred}{Should the variance-covariance matrix include the extrapolated
values as well (if any) ?}

\item{...}{Not used}
}
\value{
The variance-covariance matrix for the fitted values
}
\description{
The variance-covariance matrix may be useful in case confidence intervals are
required for quantities derived from the fitted values.
}
\examples{

object <- WH(portfolio_mort$d, portfolio_mort$ec)
vcov(object)

object_extra <- predict(object, newdata = 40:99)
V <- vcov(object_extra)

}
