% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_SS.R
\name{base}
\alias{base}
\title{Compute the baseline parameters needed for sample size calculation for
standard win ratio test}
\usage{
base(lambda_D, lambda_H, kappa, tau_b, tau, lambda_L, N = 1000, seed = 12345)
}
\arguments{
\item{lambda_D}{Baseline hazard \eqn{\lambda_D} for death.}

\item{lambda_H}{Baseline hazard \eqn{\lambda_H} for nonfatal event.}

\item{kappa}{Gumbel--Hougaard copula correlation parameter \eqn{\kappa}.}

\item{tau_b}{Length of the initial (uniform) accrual period \eqn{\tau_b}.}

\item{tau}{Total length of follow-up \eqn{\tau}.}

\item{lambda_L}{Exponential hazard rate \eqn{\lambda_L} for random loss to follow-up.}

\item{N}{Simulated sample size for monte-carlo integration.}

\item{seed}{Seed for monte-carlo simulation.}
}
\value{
A list containing real number \code{zeta2} for \eqn{\zeta_0^2}
and bivariate vector \code{delta} for \eqn{\boldsymbol\delta_0}.
}
\description{
Compute the baseline parameters \eqn{\zeta_0^2} and \eqn{\boldsymbol\delta_0}
needed for sample size calculation for standard win ratio test (see \code{\link{WRSS}}).
The calculation is based
on a Gumbel--Hougaard copula model for survival time \eqn{D^{(a)}} and nonfatal event
time \eqn{T^{(a)}} for group \eqn{a} (1: treatment; 0: control):
\deqn{{P}(D^{(a)}>s, T^{(a)}>t) =\exp\left(-\left[\left\{\exp(a\xi_1)\lambda_Ds\right\}^\kappa+
\left\{\exp(a\xi_2)\lambda_Ht\right\}^\kappa\right]^{1/\kappa}\right),}
where \eqn{\xi_1} and \eqn{\xi_2} are the component-wise log-hazard ratios to be used
as effect size in \code{\link{WRSS}}.
We also assume that patients are recruited uniformly over the period \eqn{[0, \tau_b]}
and followed until time \eqn{\tau}  (\eqn{\tau\geq\tau_b}), with an exponential
loss-to-follow-up hazard \eqn{\lambda_L}.
}
\examples{
# see the example for WRSS
}
\references{
Mao, L., Kim, K. and Miao, X. (2021). Sample size formula for general win ratio analysis.
Biometrics, https://doi.org/10.1111/biom.13501.
}
\seealso{
\code{\link{gumbel.est}}, \code{\link{WRSS}}
}
\keyword{WRSS}
