% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gbc}
\alias{gbc}
\title{A subset of the German Breast Cancer study data}
\format{
A data frame with 985 rows and 12 variables:
\describe{
  \item{id}{subject IDs}
  \item{time}{event times (months)}
  \item{status}{event status; 0:censoring, 1:death, 2:cancer recurrence}
  \item{hormone}{treatment indicator: 1=Hormone therapy; 2=standard therapy}
  \item{age}{age at diagnosis (years)}
  \item{menopause}{menopausal Status; 1=No; 2=Yes}
  \item{size}{tumor size}
  \item{grade}{tumor grade, 1-3}
  \item{nodes}{number of nodes involved}
  \item{prog_recp}{number of progesterone receptors}
  \item{estrg_recp}{number of estrogen receptors}
  }
}
\usage{
gbc
}
\description{
These are a subset of the German Breast Cancer study data.
}
\references{
Sauerbrei, W., Royston, P., Bojar, H., Schmoor, C. and Schumacher, M.
(1999). Modelling the effects of standard prognostic factors in node-positive
breast cancer. German Breast Cancer Study Group (GBSG). British Journal of Cancer,
79, 1752–1760.

Hosmer, D.W. and Lemeshow, S. and May, S. (2008) Applied Survival
Analysis: Regression Modeling of Time to Event Data: Second Edition, John Wiley
and Sons Inc., New York, NY
}
\keyword{datasets}
