% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_SS.R
\name{gumbel.est}
\alias{gumbel.est}
\title{Estimate baseline parameters in the Gumbel--Hougaard model for sample size
calculation using pilot data}
\usage{
gumbel.est(id, time, status)
}
\arguments{
\item{id}{A vector of unique patient identifiers.}

\item{time}{A numeric vector of event times.}

\item{status}{A vector of event type variable; 2 = nonfatal event, 1 = death,
and 0 = censoring.}
}
\value{
A list containing \code{lambda_D} for \eqn{\lambda_D},
\code{lambda_H} for \eqn{\lambda_H}, and \code{kappa} for \eqn{\kappa}
in the Gumbel--Hougaard model.
}
\description{
Estimate baseline parameters in the Gumbel--Hougaard model
described in \code{\link{base}} for sample size calculation using pilot study data.
}
\examples{
# see the example for WRSS
}
\references{
Mao, L., Kim, K. and Miao, X. (2021). Sample size formula for general win ratio analysis.
Biometrics, https://doi.org/10.1111/biom.13501.
}
\seealso{
\code{\link{base}}, \code{\link{WRSS}}
}
\keyword{WRSS}
