% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal-distribution.R
\name{normal-distribution-methods}
\alias{normal-distribution-methods}
\alias{dwnorm}
\alias{rwnorm}
\title{Normal distribution methods for \code{SWoodburyMatrix} objects}
\usage{
dwnorm(x, mean, covariance, log = FALSE)

rwnorm(n, mean, covariance)
}
\arguments{
\item{x}{A numeric vector or matrix.}

\item{mean}{Optional mean vector; defaults to zero mean.}

\item{covariance}{\code{WoodburyMatrix} object.}

\item{log}{Logical indicating whether to return log of density.}

\item{n}{Number of samples to return. If \code{n = 1}, returns a vector,
otherwise returns an \code{n} by \code{nrow(W)} matrix.}
}
\description{
Draw samples and compute density functions for the multivariate normal
distribution with an \code{SWoodburyMatrix} object as its covariance matrix.
}
\section{Functions}{
\itemize{
\item \code{dwnorm()}: Compute the density of the
distribution

\item \code{rwnorm()}: Draw samples from the distribution

}}
\examples{
library(Matrix)
# Trivial example with diagonal covariance matrices
W <- WoodburyMatrix(Diagonal(10), Diagonal(10))
x <- rwnorm(10, covariance = W)
print(dwnorm(x, covariance = W, log = TRUE))
}
\seealso{
\link{WoodburyMatrix}
}
