% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/W2IP.R
\name{W2IP}
\alias{W2IP}
\title{2-Wasserstein distance selection by Integer Programming}
\usage{
W2IP(
  X,
  Y = NULL,
  theta,
  transport.method = transport_options(),
  model.size = NULL,
  nvars = NULL,
  maxit = 100L,
  infimum.maxit = 100L,
  tol = 1e-07,
  solver = c("cone", "lp", "mosek", "cplex", "gurobi"),
  display.progress = FALSE,
  parallel = NULL,
  ...
)
}
\arguments{
\item{X}{Covariates}

\item{Y}{Predictions from arbitrary model}

\item{theta}{Parameters of original linear model. Required}

\item{transport.method}{Method for Wasserstein distance calculation. Should be one of the outputs of \code{\link[=transport_options]{transport_options()}}.}

\item{model.size}{Maximum number of coefficients in interpretable model}

\item{nvars}{The number of variables to explore. Should be an integer vector of model sizes. Default is NULL which will explore all models from 1 to \code{model.size}.}

\item{maxit}{Maximum number of solver iterations}

\item{infimum.maxit}{Maximum iterations to alternate binary program and Wasserstein distance calculation}

\item{tol}{Tolerance for convergence of coefficients}

\item{solver}{The solver to use. Must be one of "cone","lp", "cplex", "gurobi","mosek".}

\item{display.progress}{Should progress be printed?}

\item{parallel}{foreach back end. See \code{\link[foreach:foreach]{foreach::foreach()}} for more details.}

\item{...}{Extra args to Wasserstein distance methods}
}
\description{
2-Wasserstein distance selection by Integer Programming
}
\details{
For argument \code{solution.method}, options "cone" and "lp" use the free solvers "ECOS" and "lpSolver", respectively. "cplex", "gurobi" and "mosek" require installing the corresponding commercial solvers.
}
\keyword{internal}
